% Performs Huffman encoding and decoding

clear all

% Define your codewords here
codewords{1} = [1  1  1  1];
codewords{2} = [0  1  0  1  1  0];
codewords{3} = [0  1  0  1  0];
codewords{4} = [1  1  0  1  0];
codewords{5} = [1  0  0];
codewords{6} = [1  0  1  0  0];
codewords{7} = [1  1  0  1  1  1];
codewords{8} = [0  1  0  0];
codewords{9} = [0  1  1  1];
codewords{10} = [1  1  0  1  1  0  1  1  1  0];
codewords{11} = [1  1  0  1  1  0  1  0];
codewords{12} = [1  0  1  0  1];
codewords{13} = [0  0  0  1  0];
codewords{14} = [1  1  0  0];
codewords{15} = [1  1  1  0];
codewords{16} = [0  0  0  0  0];
codewords{17} = [1  1  0  1  1  0  1  1  0  1];
codewords{18} = [1  0  1  1];
codewords{19} = [0  1  1  0];
codewords{20} = [0  0  1];
codewords{21} = [0  0  0  1  1];
codewords{22} = [1  1  0  1  1  0  0];
codewords{23} = [0  1  0  1  1  1];
codewords{24} = [1  1  0  1  1  0  1  1  1  1];
codewords{25} = [0  0  0  0  1];
codewords{26} = [1  1  0  1  1  0  1  1  0  0];

% Build a binary tree to help the decoding process
tree = zeros(1,4);
% For each codeword...
for codeword_index = 1:length(codewords)
    % Start at the root node
    node = 1;
    % For every bit in the codeword, except for the last...
    for bit_index = 1:(length(codewords{codeword_index})-1)
        % If the bit is a 0...
        if codewords{codeword_index}(bit_index) == 0
            % If a node has not been created to handle the sequence of bits in the codeword so far...
            if tree(node,1) == 0
                % ...create a node and a branch to it
                tree(node,1) = size(tree,1)+1;
                tree(size(tree,1)+1,:) = zeros(1,4);  
            end
            % Navigate to the node that handles the sequence of bits in the codeword so far
            node = tree(node,1);
        % ...else the bit is a 1
        else
            % If a node has not been created to handle the sequence of bits in the codeword so far...
            if tree(node,2) == 0
                % ...create a node and a branch to it
                tree(node,2) = size(tree,1)+1;
                tree(size(tree,1)+1,:) = zeros(1,4);  
            end
            % Navigate to the node that handles the sequence of bits in the codeword so far
            node = tree(node,2);
        end
    end
    % If the final bit in the codeword is a 0...
	if codewords{codeword_index}(length(codewords{codeword_index})) == 0
        % Associate the current node with the codeword index and create a branch back to the root node
        tree(node,1) = 1;
        tree(node,3) = codeword_index;
    % ...else the final bit is a 1
	else
        % Associate the current node with the codeword index and create a branch back to the root node
        tree(node,2) = 1;
        tree(node,4) = codeword_index;
	end
end

% Encoder
% =======

% Define the symbols to be encoded here
symbols = [8 5 12 12 15 23 15 18 12 4]; %helloworld

% Create an empty vector to store the bits in
bits = [];
% For each symbol...
for symbol_index = 1:length(symbols);
    % ...concatenate the associated codeword onto the bit sequence
    bits = [bits, codewords{symbols(symbol_index)}];
end
% Display the bits
bits


% Decoder
% =======

% Create an empty vector to store the recovered symbols in
recovered_symbols = [];
% Start at the root node of the binary tree
node = 1;
% For each bit...
for bit_index = 1:length(bits)
    % If the bit is a 0...
    if bits(bit_index) == 0
        % If the node is associated with a codeword index...
        if tree(node,3) ~= 0
            % ...concatenate the codeword index onto the sequence of symbols recovered so far
            recovered_symbols = [recovered_symbols, tree(node,3)];
        end
        % Navigate to the next node
        node = tree(node,1);
    else
        % If the node is associated with a codeword index...
        if tree(node,4) ~= 0
            % ...concatenate the codeword index onto the sequence of symbols recovered so far
            recovered_symbols = [recovered_symbols, tree(node,4)];
        end
        % Navigate to the next node
        node = tree(node,2);
    end
end
% Display the recovered symbols
recovered_symbols
