d3.queue()
.defer(d3.csv, "chocolate-bars-csv.csv", 
  function(data, i) {
    return {
      id: i,
      company: data["Company"],
      name: data["Name"],
      ref: data["Ref"],
      percent: +data["Cocoa Percent"],
      loc: data["Company Location"],
         origin: data["Broad Bean Origin"],
         type: data["Bean Type"],
      rating: +data["Rating"],
      date: +data["Review Date"],
      choconame: data["Company"]+"-"+data["Name"]
    };
  })
.await(analyze);

function analyze(error, dataset) {
  if (error) { 
    console.log(error);
    return; 
  }

  //dataset = dataset.slice(0,10);

  var margin = { top: 30, right: 30, bottom: 30, left: 30 };

  var width = 800;
  var height = 800;

  //////////////////////////////////////////////////////////////////////////////

  var svg = d3.select('body')
      .append('svg')

      //The total width of our svg is the width of the graph, plus the size of the left and right margins
      .attr('width', width + margin.left + margin.right)

      //The total height of our svg is the height of the graph, plus the size of the top and bottom margins
      .attr('height', height + margin.top + margin.bottom) 

      //We can't see the svg yet - but if you want to check it's worked, you can set the background colour to pink!
      //.style('background-color', 'pink')

      //Then, we're going to add a "group", so we can move the whole graph in one go
      //This lets us make room for the margins easily
      .append('g')
      .attr('transform', 'translate(' + margin.left + ',' + margin.top + ")");

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  var y = d3.scaleLinear()
    .domain([0, 5])
    .range([height, 0]);
  
  var x = d3.scaleLinear()
    .domain([0, 100])                    
    .range([0, width]);

  var colour = d3.scaleLinear()
    .domain([0, 50, 100])
    .range([d3.rgb("#d1a665"), d3.rgb("#7d4e29"), d3.rgb("#382001")])
  
  function jitter(v, vmin, vmax) {
    var r = v + 0.01 * (vmax - vmin) * (Math.random() - 0.5);
    return Math.min(vmax, Math.max(vmin, r));
  }

  var points = svg.selectAll(".point")
    .data(dataset)
    .enter()
    .append("circle")
    .attr("class", "point")
    .attr("cy", function(d) {
      return y(jitter(d.rating, 0, 5.0));
    })
    .attr("cx", function(d) {
      return x(jitter(d.percent, 0, 100.0));
    })
    .attr("r", 5)
    .attr("stroke", function(d) { return colour(d.percent); })
    .attr("fill", "none")
    .attr("opacity", 0.8)
    ;

  // add the x Axis
  svg.append("g")
    .attr("transform", "translate(0," + height + ")")
    .call(d3.axisBottom(x));
    
  // add the y Axis
  svg.append("g")
    .call(d3.axisLeft(y));

}  