d3.queue()
.defer(d3.csv, "chocolate-bars-csv.csv", 
  function(data, i) {
    return {
      id: i,
      company: data["Company"],
      name: data["Name"],
      ref: data["Ref"],
      percent: data["Cocoa Percent"],
      loc: data["Company Location"],
         origin: data["Broad Bean Origin"],
         type: data["Bean Type"],
      rating: +data["Rating"],
      date: +data["Review Date"],
      choconame: data["Company"]+"-"+data["Name"]
    };
  })
.await(analyze);

function analyze(error, dataset) {
  if (error) { 
    console.log(error);
    return; 
  }

                //dataset = dataset.filter(function(d){return d.date===2006;});
                dataset = dataset.sort(function (a, b) {
                    return d3.ascending(a.rating, b.rating);
                })

                var margin = { top: 30, right: 30, bottom: 30, left: 300 };

                var width = 800;
                var height = dataset.length*30;

                //////////////////////////////////////////////////////////////////////////////

                var svg = d3.select('body')
                    .append('svg')

                    //The total width of our svg is the width of the graph, plus the size of the left and right margins
                    .attr('width', width + margin.left + margin.right)

                    //The total height of our svg is the height of the graph, plus the size of the top and bottom margins
                    .attr('height', height + margin.top + margin.bottom) 

                    //We can't see the svg yet - but if you want to check it's worked, you can set the background colour to pink!
                    //.style('background-color', 'pink')

                    //Then, we're going to add a "group", so we can move the whole graph in one go
                    //This lets us make room for the margins easily
                    .append('g')
                    .attr('transform', 'translate(' + margin.left + ',' + margin.top + ")");

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                //A Band scale is good for discrete values, such as the number of bars in a bar chart
                var y = d3.scaleBand()
                    .domain(dataset.map(function(d) { return d.id;}))
                    .range([0, height])
                    .padding(0.1);

                //This tells us the width of each bar that will fit nicely in our chart,
                //given the size of our graph, the number of inputs, and the amount of padding
                //console.log(x.bandwidth());

                //A Linear scale is good for continuous values, such as real numbers
                var x = d3.scaleLinear()
                    .domain([0, d3.max(dataset, function(d) { return d.rating; })])                    
                    .range([0, width]);

                //This tells us how many pixels tall our bar would be, to represent an input of "8"
                //console.log(y(8));

                var colour = d3.scaleLinear()
                    .domain([0, 50, 100])
                    .range([d3.rgb("#d1a665"), d3.rgb("#7d4e29"), d3.rgb("#382001")])

                ///////////////////////////////////////////

                 var bars = svg.selectAll(".bar")
                    .data(dataset)
                    .enter()
                    .append("g")
                    .attr("class", "bar");
                
                bars.append("text")
                    .attr("class", "label")
                    //y position of the label is halfway down the bar
                    .attr("y", function(d) {
                        return y(d.id) + y.bandwidth() / 2 + 4;
                    })
                    //x position is 3 pixels to the right of the bar
                    .attr("x", function(d) {
                        return x(d.rating) + 3;
                    })
                    .text(function(d) { return d.rating; })
                    ;

                 bars.append("rect")
                    .attr("class", "bar")
                    .attr("height", y.bandwidth())
                    .attr("width", function(d) { return x(d.rating); })
                    .attr("x", 0)
                    .attr("y", function(d) { return y(d.id); })
                    .attr("fill", function(d) { return colour(d.percent); })
                    ;

                  // add the x Axis
                  svg.append("g")
                      .attr("transform", "translate(0," + height + ")")
                      .call(d3.axisBottom(x));
                      
                  // add the y Axis
                  svg.append("g")
                      .call(d3.axisLeft(y).tickSize(0)
                      .tickFormat(function(d, i) {
                        return dataset[i].choconame;
                      })
                    );
            }