/* 
	Southampton University - Learning Object JS - p.16 References
	(Oct 2013 - www.sjward.org)
	-------------------------------------------------------------- */

var SU = {
	
	qty: 6,
	
	last: false,
	
	pics: {},
		
	init: function() {
		var j;
		for ( j = 0; j < this.qty; j += 1 ) {
			this.add_listener(j);
		}
		
		//backgrounds
		this.pics.circle_0 = new Image();
		this.pics.circle_0.src = 'css/images/circle-320_0.gif';
		
		this.pics.circle_1 = new Image();
		this.pics.circle_1.src = 'css/images/circle-320_1.gif';
		
		this.pics.circle_2 = new Image();
		this.pics.circle_2.src = 'css/images/circle-320_2.gif';
		
		this.pics.circle_3 = new Image();
		this.pics.circle_3.src = 'css/images/circle-320_3.gif';
		
		this.pics.circle_4 = new Image();
		this.pics.circle_4.src = 'css/images/circle-320_4.gif';
		
		this.pics.circle_5 = new Image();
		this.pics.circle_5.src = 'css/images/circle-320_5.gif';
		
		//hovers
		this.pics.segT_0 = new Image();
		this.pics.segT_0.src = 'css/images/segT_0.png';
		
		this.pics.segT_1 = new Image();
		this.pics.segT_1.src = 'css/images/segT_1.png';
		
		this.pics.segT_2 = new Image();
		this.pics.segT_2.src = 'css/images/segT_2.png';
		
		this.pics.segT_3 = new Image();
		this.pics.segT_3.src = 'css/images/segT_3.png';
		
		this.pics.segT_4 = new Image();
		this.pics.segT_4.src = 'css/images/segT_4.png';
		
		this.pics.segT_5 = new Image();
		this.pics.segT_5.src = 'css/images/segT_5.png';		
	},
	
	add_listener: function(j) {
		var that = this;
		$('#seg_' + j).mouseover( function(e) {
			$('#circlesegs').attr('src', 'css/images/segT_' + j + '.png');
		});
		
		$('#seg_' + j).mouseout( function(e) {
				$('#circlesegs').attr('src', 'css/images/clear.png');
		});
		
		$('#seg_' + j).click( function(e) {
			if ( false !== that.last && j !== that.last  ) {
				$('#reveal_' + that.last).hide();
			}
			if ( j !== that.last ) {
				if ( false === that.last ) {
					$('#reveal_' + j).fadeIn(300);
				} else {
					$('#reveal_' + j).show();
					
				}
				$('.circle').removeClass("bg_" + that.last).addClass("bg_" + j);
				that.last = j;
			}
			e.preventDefault();
		});
				
		$('#closer_' + j).click( function(e) {
			$('#reveal_' + j).fadeOut(300);
			$('.circle').removeClass("bg_"+j).addClass("circle");
			that.last = false;
		});
	}
	
};


$(document).ready( function() {
	
	SU.init();

});
