/* 
	Southampton University - Learning Object JS - p.14 Plagiarism
	(Oct 2013 - www.sjward.org)
	-------------------------------------------------------------- */

var SU = {
	
	qty: 4,
	
	last: false,
	
	toggle: false,
	
	pics: {},
	
	init: function() {
		var j;
		for ( j = 0; j < this.qty; j += 1 ) {
			this.add_listener(j);
		}
		
		this.pics.tableH = new Image();
		this.pics.tableH.src = 'css/images/table-H-40pc.png';
		
		this.pics.tog = new Image();
		this.pics.tog.src = 'css/images/arrow-close.png';
	},
	
	add_listener: function(j) {
		var that = this;
		$('#info_' + j).click( function(e) {
			if ( false !== that.last && j !== that.last  ) {
				$('#reveal_' + that.last).hide();
				$('#feedback_' + that.last).hide();
				$('#feedback_' + that.last + ' .fbody').hide();
				$('#feedback_' + that.last + ' .fhead .togglebutton').removeClass('arrow-close').addClass('arrow-open');
				that.toggle = false;
			}
			if ( j !== that.last ) {
				if ( false === that.last ) {
					$('#reveal_' + j).fadeIn(300);
					$('#feedback_' + j).fadeIn(300);
				} else {
					$('#reveal_' + j).show();
					$('#feedback_' + j).show();
				}
				that.last = j;
				that.add_alpha(j);
				//that.show_feedback(j);
			}
			e.preventDefault();
		});
		
		$('#closer_' + j).click( function(e) {
			$('#reveal_' + j).fadeOut(300);
			$('#feedback_' + j).hide();
			$('#feedback_' + j + ' .fbody').hide();
			$('#feedback_' + j + ' .fhead .togglebutton').removeClass('arrow-close').addClass('arrow-open');
			that.remove_alpha();
			that.last = false;
			that.toggle = false;
		});
		
		$('#feedback_' + j + ' .togglebutton').click( function(e) {
			that.toggle_feedback(j);
		});
		
	},
	
	add_alpha: function(j) {
		var i;
		for ( i = 0; i < this.qty; i += 1 ) {
			if ( i !== j ) {
				$('#info_' + i).removeClass('selected');
				$('#info_' + i).addClass('alpha');	
			} else {
				$('#info_' + i).removeClass('alpha');
				$('#info_' + i).addClass('selected');
			}
		}
	},
	
	remove_alpha: function(j) {
		var i;
		for ( i = 0; i < this.qty; i += 1 ) {
			$('#info_' + i).removeClass('selected');
			$('#info_' + i).removeClass('alpha');
		}
	},
	
	show_feedback: function(j) {
		if ( false !== this.last ) {
			$('#feedback_' + this.last).hide();
			$('#feedback_' + this.last + ' .fbody').hide();
			this.toggle = false;
		}
		$('#feedback_' + j).show();
	},
	
	toggle_feedback: function(j) {
		if ( this.toggle ) {
			$('#feedback_' + j + ' .fbody').hide();
			$('#feedback_' + j + ' .fhead .togglebutton').removeClass('arrow-close').addClass('arrow-open');
			this.toggle = false;
		} else {
			$('#feedback_' + j + ' .fbody').show();
			$('#feedback_' + j + ' .fhead .togglebutton').removeClass('arrow-open').addClass('arrow-close');
			this.toggle = true;
		}
	}
	
};


$(document).ready( function() {
	
	SU.init();

});
