/* 
	Southampton University - Learning Object JS - p.10 Bibliography
	(Oct 2013 - www.sjward.org)
	--------------------------------------------------------------- */

var SU = {
	
	qty: 5,
	
	last: false,
	
	pics: {},
	
	init: function() {
		var j;
		for ( j = 0; j < this.qty; j += 1 ) {
			this.add_listener(j);
		}
		
		this.pics.arrow_left_H = new Image();
		this.pics.arrow_left_H.src = 'css/images/arrow-left-H.gif';
		
		this.pics.arrow_right_H = new Image();
		this.pics.arrow_right_H.src = 'css/images/arrow-right-H.gif';
	},
	
	add_listener: function(j) {
		var that = this;
		$('#sign_' + j).click( function(e) {
			if ( false !== that.last && j !== that.last  ) {
				$('#reveal_' + that.last).hide();
			}
			if ( j !== that.last ) {
				if ( false === that.last ) {
					$('#reveal_' + j).fadeIn(300);
				} else {
					$('#reveal_' + j).show();
				}
				that.last = j;
				that.add_alpha(j);
			}
			e.preventDefault();
		});
		
		$('#closer_' + j).click( function(e) {
			$('#reveal_' + j).fadeOut(300);
			that.remove_alpha();
			that.last = false;
		});
	},
	
	add_alpha: function(j) {
		var i;
		for ( i = 0; i < this.qty; i += 1 ) {
			if ( i !== j ) {
				$('#sign_' + i).removeClass('selected');
				$('#sign_' + i).addClass('alpha');	
			} else {
				$('#sign_' + i).removeClass('alpha');
				$('#sign_' + i).addClass('selected');
			}
		}
	},
	
	remove_alpha: function(j) {
		var i;
		for ( i = 0; i < this.qty; i += 1 ) {
			$('#sign_' + i).removeClass('selected');
			$('#sign_' + i).removeClass('alpha');
		}
	}
	
};


$(document).ready( function() {
	
	SU.init();

});
