function draw(data) {
	d3.select("#graph")
		.append("div")
		.attr("class","chart")
		.selectAll(".bar")
		.data(data.cash)
		.enter()
		.append("div")
		.attr("class","bar")
		.attr("id",function(d) {return d.id})
		.attr("name",function(d) {return d.name})
		.style("width", function(d) {return d.count/100 + "px"})
		.style("outline", "1px solid black")
		.text(function(d){return Math.round(d.count)});
	d3.selectAll(".bar")
		.on("click", do_something);

}
function do_something() {
	var name = d3.select(this).attr("name");
	d3.select("#dynamic").text(name);
}
