// JavaScript Document

var questions = new Array();

function addQuestion(text, correctAnswer, falseAnswers)
{
	var q = {text: text, correctAnswer: correctAnswer, falseAnswers: falseAnswers};
	questions.push(q);
}

function showQuestionnaire()
{
	var elem = document.getElementById("questionnaire-form");
	for (q in questions)
	{
		var x = 1;
		x += (q * 1);
		elem.innerHTML += "<h5> " + x + ". " + questions[q].text + "</h5>";
		
		//Shuffle answers
		var answers = questions[q].falseAnswers;
		answers.push(questions[q].correctAnswer);
		
		var shuffledAnswers = new Array();
		var i = 0;
		while (answers.length > 0)
		{
			var r = Math.floor(Math.random() * answers.length);
			shuffledAnswers[i++] = answers[r];
			answers.splice(r, 1);
		}
		
		while(i--)
		{
			elem.innerHTML += "<input type=\"radio\" name=\"" + q + "\" value=\"" + shuffledAnswers[i] + "\">" + shuffledAnswers[i] + "</input><br />";
		}
	}
	
	elem.innerHTML += '<br /><input type="submit" value="Check Answers" />';
}

function checkAnswers()
{
	var opts = document.body.getElementsByTagName("input");
	var output = "Results:\n";
	var correct = 0;
	var total = 0;
	
	for (i in opts)
	{
		if (opts[i].type == "radio")
		{
			var q = opts[i].name;
			var checked = opts[i].checked;
			
			if (opts[i].value == questions[q].correctAnswer)
			{
				total++;
				q = 1 + q * 1;
				if (checked)
				{
					output += "\nQuestion " + q + ": Correct!";
					correct++;
				}
				else
					output += "\nQuestion " + q + ": Incorrect!";
			}
		}
	}
	
	output += "\n\nTotal: " + correct + " / " + total;
	alert(output);
	
	return false;
}